﻿//////////////////////////////////////////////
// Constants.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkMemory
#include <NilkinsMemory/Containers/String.h>

/// Class ------------------------------------

namespace nkAstraeus::nkGraphicsWrap
{
	struct Constants
	{
		// Namespace
		inline static const nkMemory::String NAMESPACE = "nkGraphics" ;

		// UserTypes
		// Bounds
		inline static const nkMemory::String BOUNDING_BOX = NAMESPACE + ".BoundingBox" ;

		// Camera
		inline static const nkMemory::String CAMERA = NAMESPACE + ".Camera" ;
		inline static const nkMemory::String CAMERA_MANAGER = NAMESPACE + ".CameraManager" ;
		inline static const nkMemory::String FRUSTUM = NAMESPACE + ".Frustum" ;

		// Compositor
		inline static const nkMemory::String COMPOSITOR = NAMESPACE + ".Compositor" ;
		inline static const nkMemory::String COMPOSITOR_MANAGER = NAMESPACE + ".CompositorManager" ;
		inline static const nkMemory::String COMPOSITOR_NODE = NAMESPACE + ".CompositorNode" ;

		// Encoders
		inline static const nkMemory::String GLTF_ENCODER = NAMESPACE + ".GltfEncoder" ;

		// Graph
		inline static const nkMemory::String ENTITY = NAMESPACE + ".Entity" ;
		inline static const nkMemory::String NODE = NAMESPACE + ".Node" ;
		inline static const nkMemory::String NODE_MANAGER = NAMESPACE + ".NodeManager" ;

		// Meshes
		inline static const nkMemory::String MESH = NAMESPACE + ".Mesh" ;
		inline static const nkMemory::String MESH_MANAGER = NAMESPACE + ".MeshManager" ;
		inline static const nkMemory::String VERTEX_COMPONENT = NAMESPACE + ".VertexComponent" ;
		inline static const nkMemory::String VERTEX_COMPONENT_ARRAY = NAMESPACE + ".VertexComponentArray" ;
		inline static const nkMemory::String VERTEX_COMPOSITION = NAMESPACE + ".VertexComposition" ;

		// Programs
		inline static const nkMemory::String PROGRAM = NAMESPACE + ".Program" ;
		inline static const nkMemory::String PROGRAM_MANAGER = NAMESPACE + ".ProgramManager" ;

		// RenderContexts
		inline static const nkMemory::String RENDER_CONTEXT = NAMESPACE + ".RenderContext" ;
		inline static const nkMemory::String RENDER_CONTEXT_MANAGER = NAMESPACE + ".RenderContextManager" ;

		// RenderQueues
		inline static const nkMemory::String RENDER_QUEUE = NAMESPACE + ".RenderQueue" ;
		inline static const nkMemory::String RENDER_QUEUE_MANAGER = NAMESPACE + ".RenderQueueManager" ;

		// Shaders
		inline static const nkMemory::String SHADER = NAMESPACE + ".Shader" ;
		inline static const nkMemory::String SHADER_MANAGER = NAMESPACE + ".ShaderManager" ;

		// Textures
		inline static const nkMemory::String TEXTURE = NAMESPACE + ".Texture" ;
		inline static const nkMemory::String TEXTURE_MANAGER = NAMESPACE + ".TextureManager" ;
		inline static const nkMemory::String TEXTURE_SAVER = NAMESPACE + ".TextureSaver" ;
		inline static const nkMemory::String TEXTURE_UTILS = NAMESPACE + ".TextureUtils" ;

		// Viewports
		inline static const nkMemory::String VIEWPORT = NAMESPACE + ".Viewport" ;
		inline static const nkMemory::String VIEWPORT_MANAGER = NAMESPACE + ".ViewportManager" ;
	} ;
}